<?php
// Enable CORS for development
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}


require_once('assets/init.php');
decryptConfigData();
$api_version = '1.3.1';
if (empty($_GET['type']) || !isset($_GET['type'])) {
    $json_error_data = array(
        'api_status' => 'failed',
        'api_version' => $api_version,
        'errors' => array(
            'error_id' => '3',
            'error_text' => 'Bad request.'
        )
    );
    header("Content-type: application/json");
    echo json_encode($json_error_data, JSON_PRETTY_PRINT);
    exit();
}
$types  = array(
    'user_data',
    'posts_data',
    'search',
    'get_actualites',       
    'get_actualite_detail', 
    'get_categories',
    'get_thematiques',       
    'get_thematique_detail', 
    'get_faqs',
    'get_evenements',
    'get_evenement_detail',
    'get_contacts_urgence'            
);
$result = array();
$limit  = 20;
if (isset($_GET['limit']) && !empty($_GET['limit'])) {
    $limit = Wo_Secure($_GET['limit']);
}
if (!is_numeric($limit)) {
    $limit = 20;
}
if ($limit > 100) {
    $limit = 100;
}
if (!in_array($_GET['type'], $types)) {
    $json_error_data = array(
        'api_status' => 'failed',
        'api_version' => $api_version,
        'errors' => array(
            'error_id' => '3',
            'error_text' => 'Bad request.'
        )
    );
    header("Content-type: application/json");
    echo json_encode($json_error_data, JSON_PRETTY_PRINT);
    exit();
}

if ($_GET['type'] == 'user_data') {
    $api_data = Wo_UserData(Wo_UserIdFromUsername($_GET['user']));
    if (empty($api_data)) {
        $json_error_data = array(
            'api_status' => 'failed',
            'api_version' => $api_version,
            'errors' => array(
                'error_id' => '1',
                'error_text' => 'Username is not exists.'
            )
        );
        header("Content-type: application/json");
        echo json_encode($json_error_data, JSON_PRETTY_PRINT);
        exit();
    }
    $json_data = array(
        'id' => $api_data['user_id'],
        'username' => $api_data['username'],
        'first_name' => $api_data['first_name'],
        'last_name' => $api_data['last_name'],
        'gender' => $api_data['gender'],
        'birthday' => $api_data['birthday'],
        'about' => $api_data['about'],
        'website' => $api_data['website'],
        'facebook' => $api_data['facebook'],
        'twitter' => $api_data['twitter'],
        'vk' => $api_data['vk'],
        'google+' => $api_data['google'],
        'profile_picture' => $api_data['avatar'],
        'cover_picture' => $api_data['cover'],
        'verified' => $api_data['verified'],
        'url' => $api_data['url']
    );
    header("Content-type: application/json");
    echo json_encode(array(
        'api_status' => 'success',
        'api_version' => $api_version,
        'user_data' => $json_data
    ), JSON_PRETTY_PRINT);
    exit();
} elseif ($_GET['type'] == 'posts_data') {
    $publisher_id = Wo_UserIdFromUsername($_GET['user']);
    if (empty($publisher_id)) {
        $json_error_data = array(
            'api_status' => 'failed',
            'api_version' => $api_version,
            'errors' => array(
                'error_id' => '1',
                'error_text' => 'Username is not exists.'
            )
        );
        header("Content-type: application/json");
        echo json_encode($json_error_data, JSON_PRETTY_PRINT);
        exit();
    }
    $api_data = Wo_GetPosts(array(
        'limit' => $limit,
        'publisher_id' => $publisher_id
    ));
    if (empty($api_data)) {
        $json_error_data = array(
            'api_status' => 'failed',
            'api_version' => $api_version,
            'errors' => array(
                'error_id' => '2',
                'error_text' => 'User does not have any posts.'
            )
        );
        header("Content-type: application/json");
        echo json_encode($json_error_data, JSON_PRETTY_PRINT);
        exit();
    }
    header("Content-type: application/json");
    //$new = array_merge( $result, array( "api_status" => "success", "api_version" => '1.0' ) );
    foreach ($api_data as $post_data) {
        $json_data = array(
            'post_id' => $post_data['post_id'],
            'post_data' => array(
                'post_id' => $post_data['post_id'],
                'post_text' => $post_data['postText'],
                'post_file' => Wo_GetMedia($post_data['postFile']),
                'post_soundcloud' => $post_data['postSoundCloud'],
                'post_youtube' => $post_data['postYoutube'],
                'post_vine' => $post_data['postVine'],
                'post_map' => $post_data['postMap'],
                'post_time' => $post_data['time'],
                'post_likes' => Wo_CountLikes($post_data['post_id']),
                'post_wonders' => Wo_CountWonders($post_data['post_id'])
            ),
            'publisher_data' => array(
                'id' => $post_data['publisher']['user_id'],
                'username' => $post_data['publisher']['username'],
                'first_name' => $post_data['publisher']['first_name'],
                'last_name' => $post_data['publisher']['last_name'],
                'gender' => $post_data['publisher']['gender'],
                'birthday' => $post_data['publisher']['birthday'],
                'about' => $post_data['publisher']['about'],
                'website' => $post_data['publisher']['website'],
                'facebook' => $post_data['publisher']['facebook'],
                'twitter' => $post_data['publisher']['twitter'],
                'vk' => $post_data['publisher']['vk'],
                'google+' => $post_data['publisher']['google'],
                'profile_picture' => $post_data['publisher']['avatar'],
                'cover_picture' => $post_data['publisher']['cover'],
                'verified' => $post_data['publisher']['verified'],
                'url' => $post_data['url']
            )
        );
        array_push($result, $json_data);
    }
    echo json_encode(array(
        'api_status' => 'success',
        'api_version' => $api_version,
        'items' => $result
    ), JSON_PRETTY_PRINT);
    exit();
} else if ($_GET['type'] == 'search') {
    if (!empty($_GET['gender'])) {
        if ($_GET['gender'] == 'male') {
            $filter['gender'] = 'male';
        } else if ($_GET['gender'] == 'female') {
            $filter['gender'] = 'female';
        }
    }
    if (!empty($_GET['image'])) {
        if ($_GET['image'] == 'yes') {
            $filter['image'] = 'yes';
        } else if ($_GET['image'] == 'no') {
            $filter['image'] = 'no';
        }
    }
    $filter['query'] = '';
    if (!empty($_GET['keyword'])) {
        $filter['query'] = Wo_Secure($_GET['keyword']);
    }
    if (empty($_GET['keyword'])) {
        header("Content-type: application/json");
        echo json_encode(array(
            'api_status' => 'failed',
            'api_version' => $api_version,
            'errors' => array(
                'error_id' => '5',
                'error_text' => 'Keyword is empty'
            )
        ), JSON_PRETTY_PRINT);
        exit();
    }
    $api_data = Wo_GetSearchFilter($filter, $limit);
    if (empty($api_data)) {
        header("Content-type: application/json");
        echo json_encode(array(
            'api_status' => 'failed',
            'api_version' => $api_version,
            'errors' => array(
                'error_id' => '5',
                'error_text' => 'No result found'
            )
        ), JSON_PRETTY_PRINT);
        exit();
    }
    foreach ($api_data as $user_data) {
        $json_data = array(
            'id' => $user_data['user_id'],
            'username' => $user_data['username'],
            'first_name' => $user_data['first_name'],
            'last_name' => $user_data['last_name'],
            'gender' => $user_data['gender'],
            'birthday' => $user_data['birthday'],
            'about' => $user_data['about'],
            'website' => $user_data['website'],
            'facebook' => $user_data['facebook'],
            'twitter' => $user_data['twitter'],
            'vk' => $user_data['vk'],
            'google+' => $user_data['google'],
            'profile_picture' => $user_data['avatar'],
            'cover_picture' => $user_data['cover'],
            'verified' => $user_data['verified'],
            'url' => $user_data['url']
        );
        array_push($result, $json_data);
    }
    header("Content-type: application/json");
    echo json_encode(array(
        'api_status' => 'success',
        'api_version' => $api_version,
        'items' => $result
    ), JSON_PRETTY_PRINT);
    exit();
}




elseif ($_GET['type'] == 'get_actualites') {
    // --- Récupérer la liste des actualités (uniquement du type 'actualite') ---
    global $sqlConnect;
    
    $page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
    $limit = isset($_GET['limit']) && is_numeric($_GET['limit']) ? (int)$_GET['limit'] : 9;
    $offset = ($page - 1) * $limit;

    // LA MODIFICATION CLÉ : On joint TOUJOURS la table des catégories
    $join_sql = " JOIN " . T_CATEGORIES . " c ON a.category_id = c.id";
    // Et on filtre TOUJOURS par le type 'actualite'
    $where_clauses = ["a.status = 'published'", "c.type = 'actualite'"];
    
    if (!empty($_GET['category']) && $_GET['category'] !== 'all') {
        $category_slug = Wo_Secure($_GET['category']);
        $where_clauses[] = "c.slug = '{$category_slug}'";
    }

    if (!empty($_GET['search'])) {
        $search_term = Wo_Secure($_GET['search']);
        $where_clauses[] = "(a.title LIKE '%{$search_term}%' OR a.content LIKE '%{$search_term}%')";
    }

    $where_sql = implode(' AND ', $where_clauses);

    $query_str = "SELECT a.* FROM " . T_ACTUALITES . " a {$join_sql} WHERE {$where_sql} ORDER BY a.created_at DESC LIMIT {$limit} OFFSET {$offset}";
    $query = mysqli_query($sqlConnect, $query_str);
    $actualites = [];
    while ($row = mysqli_fetch_assoc($query)) {
        $row['full_image_path'] = $wo['config']['site_url'] . '/' . $row['image_path'];
        $actualites[] = $row;
    }

    $total_query = mysqli_query($sqlConnect, "SELECT COUNT(a.id) as total FROM " . T_ACTUALITES . " a {$join_sql} WHERE {$where_sql}");
    $total_result = mysqli_fetch_assoc($total_query);
    $total_items = $total_result['total'];
    
    $response = [
        'api_status'   => 'success',
        'api_version'  => $api_version,
        'data'         => $actualites,
        'pagination'   => [
            'current_page' => $page,
            'last_page'    => ceil($total_items / $limit),
            'total'        => (int)$total_items
        ]
    ];

    header("Content-type: application/json");
    echo json_encode($response, JSON_PRETTY_PRINT);
    exit();
}

elseif ($_GET['type'] == 'get_actualite_detail') {
    // --- Récupérer une seule actualité par son slug ---
    global $sqlConnect;
    if (empty($_GET['slug'])) {
        http_response_code(400);
        echo json_encode(['api_status' => 'failed', 'errors' => ['error_text' => 'Slug is required']]);
        exit();
    }
    $slug = Wo_Secure($_GET['slug']);
    $query = mysqli_query($sqlConnect, "SELECT * FROM " . T_ACTUALITES . " WHERE slug = '{$slug}' AND status = 'published'");
    
    if (mysqli_num_rows($query) > 0) {
        $actualite = mysqli_fetch_assoc($query);
        $actualite['full_image_path'] = $wo['config']['site_url'] . '/' . $actualite['image_path'];
        
        header("Content-type: application/json");
        echo json_encode(['api_status' => 'success', 'api_version' => $api_version, 'data' => $actualite], JSON_PRETTY_PRINT);
        exit();
    } else {
        http_response_code(404);
        echo json_encode(['api_status' => 'failed', 'errors' => ['error_text' => 'Article not found']]);
        exit();
    }
}

elseif ($_GET['type'] == 'get_categories') {
    // --- Récupérer la liste des catégories PAR TYPE ---
    global $sqlConnect;
    
    if (empty($_GET['category_type'])) {
        http_response_code(400);
        echo json_encode(['api_status' => 'failed', 'errors' => ['error_text' => 'Category type is required']]);
        exit();
    }
    $category_type = Wo_Secure($_GET['category_type']);

    $query_str = "SELECT id, name, slug FROM " . T_CATEGORIES . " WHERE `type` = '{$category_type}' ORDER BY name ASC";
    
    $query = mysqli_query($sqlConnect, $query_str);
    $categories = [];
    while ($row = mysqli_fetch_assoc($query)) {
        $categories[] = $row;
    }

    header("Content-type: application/json");
    echo json_encode(['api_status' => 'success', 'api_version' => $api_version, 'data' => $categories], JSON_PRETTY_PRINT);
    exit();
}

elseif ($_GET['type'] == 'get_thematiques') {
    global $sqlConnect;
    $search_term = !empty($_GET['search']) ? Wo_Secure($_GET['search']) : '';

    // <-- LA MODIFICATION CLÉ : On ajoute "c.type = 'thematique'" à la requête -->
    $sql = "SELECT c.id, c.name, c.slug 
            FROM " . T_CATEGORIES . " c 
            WHERE c.type = 'thematique' AND EXISTS (
                SELECT 1 FROM " . T_THEMATIQUES . " t 
                WHERE t.category_id = c.id AND t.status = 'published'
            )";

    if ($search_term) {
        $sql = "SELECT c.id, c.name, c.slug 
                FROM " . T_CATEGORIES . " c 
                JOIN " . T_THEMATIQUES . " t ON c.id = t.category_id
                WHERE t.status = 'published' AND c.type = 'thematique' AND (t.title LIKE '%{$search_term}%' OR t.content LIKE '%{$search_term}%')
                GROUP BY c.id";
    }
    // Le reste de la fonction ne change pas...
    $categories_query = mysqli_query($sqlConnect, $sql);
    $categories_with_thematiques = [];
    while ($category = mysqli_fetch_assoc($categories_query)) {
        $thematiques_sql = "SELECT id, title, slug FROM " . T_THEMATIQUES . " WHERE category_id = {$category['id']} AND status = 'published'";
        if ($search_term) {
             $thematiques_sql .= " AND (title LIKE '%{$search_term}%' OR content LIKE '%{$search_term}%')";
        }
        $thematiques_sql .= " ORDER BY title ASC";
        $thematiques_query = mysqli_query($sqlConnect, $thematiques_sql);
        $thematiques = [];
        while ($thematique = mysqli_fetch_assoc($thematiques_query)) {
            $thematiques[] = $thematique;
        }
        if (!empty($thematiques)) {
            $category['thematiques'] = $thematiques;
            $categories_with_thematiques[] = $category;
        }
    }
    header("Content-type: application/json");
    echo json_encode(['api_status' => 'success', 'api_version' => $api_version, 'data' => $categories_with_thematiques], JSON_PRETTY_PRINT);
    exit();
}

elseif ($_GET['type'] == 'get_thematique_detail') {
    // --- Récupérer une thématique par son slug ---
    global $sqlConnect;
    if (empty($_GET['slug'])) {
        http_response_code(400); exit();
    }
    $slug = Wo_Secure($_GET['slug']);
    $query = mysqli_query($sqlConnect, "SELECT t.*, c.name as category_name FROM " . T_THEMATIQUES . " t LEFT JOIN " . T_CATEGORIES . " c ON t.category_id = c.id WHERE t.slug = '{$slug}' AND t.status = 'published'");
    
    if (mysqli_num_rows($query) > 0) {
        $thematique = mysqli_fetch_assoc($query);
        echo json_encode(['api_status' => 'success', 'data' => $thematique], JSON_PRETTY_PRINT);
    } else {
        http_response_code(404);
        echo json_encode(['api_status' => 'failed', 'errors' => ['error_text' => 'Thematique not found']]);
    }
    exit();
}

elseif ($_GET['type'] == 'get_faqs') {
    // --- Récupérer les FAQs ---
    global $sqlConnect;
    $limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 8;
    $query = mysqli_query($sqlConnect, "SELECT * FROM " . T_FAQS . " ORDER BY id DESC LIMIT {$limit}");
    $faqs = [];
    while ($row = mysqli_fetch_assoc($query)) {
        $faqs[] = $row;
    }
    echo json_encode(['api_status' => 'success', 'data' => $faqs], JSON_PRETTY_PRINT);
    exit();
}

elseif ($_GET['type'] == 'get_evenements') {
    global $sqlConnect, $wo;
    $page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
    $limit = 9;
    $offset = ($page - 1) * $limit;

    $filter = isset($_GET['filter']) && $_GET['filter'] == 'past' ? '<' : '>=';
    $order = isset($_GET['filter']) && $_GET['filter'] == 'past' ? 'DESC' : 'ASC';
    $now = date("Y-m-d H:i:s");

    $where_sql = "date_heure {$filter} '{$now}'";
    
    $query = mysqli_query($sqlConnect, "SELECT * FROM " . T_EVENEMENTS . " WHERE {$where_sql} ORDER BY date_heure {$order} LIMIT {$limit} OFFSET {$offset}");
    $events = [];
    while ($row = mysqli_fetch_assoc($query)) {
        $row['full_image_path'] = $wo['config']['site_url'] . '/' . $row['image_path'];
        $events[] = $row;
    }

    $total_query = mysqli_query($sqlConnect, "SELECT COUNT(id) as total FROM " . T_EVENEMENTS . " WHERE {$where_sql}");
    $total_items = mysqli_fetch_assoc($total_query)['total'];
    
    $response = [
        'api_status' => 'success',
        'data' => $events,
        'pagination' => ['current_page' => $page, 'last_page' => ceil($total_items / $limit)]
    ];
    echo json_encode($response, JSON_PRETTY_PRINT);
    exit();
}

elseif ($_GET['type'] == 'get_evenement_detail') {
    global $sqlConnect, $wo;
    if (empty($_GET['id'])) { http_response_code(400); exit(); }
    $id = Wo_Secure($_GET['id']);
    $query = mysqli_query($sqlConnect, "SELECT * FROM " . T_EVENEMENTS . " WHERE id = '{$id}'");
    
    if (mysqli_num_rows($query) > 0) {
        $event = mysqli_fetch_assoc($query);
        $event['full_image_path'] = $wo['config']['site_url'] . '/' . $event['image_path'];
        echo json_encode(['api_status' => 'success', 'data' => $event], JSON_PRETTY_PRINT);
    } else {
        http_response_code(404);
    }
    exit();
}

elseif ($_GET['type'] == 'get_contacts_urgence') {
    global $sqlConnect;
    $query = mysqli_query($sqlConnect, "SELECT * FROM " . T_CONTACTS_URGENCE . " ORDER BY `type`, `name` ASC");
    $contacts_raw = [];
    while ($row = mysqli_fetch_assoc($query)) {
        $contacts_raw[] = $row;
    }

    // Regrouper par type
    $contacts_grouped = [];
    foreach ($contacts_raw as $contact) {
        $contacts_grouped[$contact['type']][] = $contact;
    }

    echo json_encode(['api_status' => 'success', 'data' => $contacts_grouped], JSON_PRETTY_PRINT);
    exit();
}

?>
