<?php
// API pour "Signaler un Abus"

// --- Initialisation des réponses ---
$json_error_data = array(
    'api_status' => '400',
    'api_text'   => 'failed',
    'errors'     => array('error_text' => 'Une erreur inattendue est survenue. Veuillez réessayer.')
);

// --- ÉTAPE 1: Validation des données POST ---
if (empty($_POST['description'])) {
    $json_error_data['errors']['error_text'] = 'Veuillez décrire ce qui s\'est passé.';
    header("Content-type: application/json");
    echo json_encode($json_error_data, JSON_PRETTY_PRINT);
    exit();
}

// --- ÉTAPE 2: Identification de l'Utilisateur ---
// L'API peut recevoir un signalement d'un utilisateur connecté ou d'un invité.
$user_id = 0;
$pseudo  = '';
$email   = '';
$phone   = '';

// Vérifie si un utilisateur est authentifié via l'API (access_token ou s)
if (!empty($_POST['user_id']) && (!empty($_POST['s']) || !empty($_POST['access_token']))) {
    $s = (!empty($_POST['s'])) ? Wo_Secure($_POST['s']) : Wo_Secure($_POST['access_token']);
    $user_login_data = Wo_UserData($_POST['user_id']);
    
    if (!empty($user_login_data) && Wo_CheckUserSessionID($_POST['user_id'], $s, $application) !== false) {
        // L'utilisateur est connecté et authentifié
        $user_id = $user_login_data['user_id'];
        $pseudo  = $user_login_data['username'];
        $email   = $user_login_data['email'];
        $phone   = $user_login_data['phone_number'];
    }
}

// Si l'utilisateur n'est pas connecté, on prend les infos du formulaire
if ($user_id === 0) {
    $pseudo  = !empty($_POST['pseudo']) ? Wo_Secure($_POST['pseudo']) : '';
    $email   = !empty($_POST['email']) ? Wo_Secure($_POST['email']) : '';
    $phone   = !empty($_POST['phone']) ? Wo_Secure($_POST['phone']) : '';
}

// --- ÉTAPE 3: Traitement des Fichiers (si présents) ---
$file_paths = array();
if (!empty($_FILES['evidences'])) {
    $files = Wo_MultipleArrayFiles($_FILES['evidences']);
    foreach ($files as $file_info) {
        if ($file_info['size'] > $wo['config']['maxUpload']) {
            continue; // Ignore les fichiers trop lourds
        }
        $media = Wo_ShareFile($file_info);
        if (!empty($media['filename'])) {
            $file_paths[] = $media['filename'];
        }
    }
}

// --- ÉTAPE 4: Insertion en Base de Données ---
$report_data = array(
    'user_id'        => $user_id,
    'pseudo'         => $pseudo,
    'email'          => $email,
    'phone'          => $phone,
    'event_date'     => Wo_Secure($_POST['event_date']),
    'description'    => Wo_Secure($_POST['description']),
    'specific_needs' => !empty($_POST['specific_needs']) ? json_encode($_POST['specific_needs']) : '[]',
    'evidences'      => json_encode($file_paths),
    'status'         => 'new',
    'time'           => time()
);

$report_id = $db->insert(T_VIOLENCE_REPORTS, $report_data);

if ($report_id) {
    $json_success_data = array(
        'api_status' => '200',
        'api_text'   => 'success',
        'message'    => "Votre signalement a été reçu avec succès. Nous vous remercions pour votre confiance."
    );
    header("Content-type: application/json");
    echo json_encode($json_success_data, JSON_PRETTY_PRINT);
    exit();
} else {
    $json_error_data['errors']['error_text'] = "Erreur lors de l'enregistrement de votre signalement.";
    header("Content-type: application/json");
    echo json_encode($json_error_data, JSON_PRETTY_PRINT);
    exit();
}