<?php
if ($f == 'report_abuse') {
    $data = array('status' => 400, 'message' => 'Une erreur inattendue est survenue. Veuillez réessayer.');

    // --- ÉTAPE 1: Validation ---
    if (empty($_POST['description'])) {
        $data['message'] = "Veuillez décrire ce qui s'est passé.";
        header("Content-type: application/json");
        echo json_encode($data);
        exit();
    }

    // --- ÉTAPE 2: Identification de l'Utilisateur ---
    if ($wo['loggedin'] == true) {
        $user_id = $wo['user']['user_id'];
        $pseudo  = Wo_Secure($wo['user']['username']);
        $email   = Wo_Secure($wo['user']['email']);
        $phone   = Wo_Secure($wo['user']['phone_number']);
    } else {
        $user_id = 0;
        $pseudo  = !empty($_POST['pseudo']) ? Wo_Secure($_POST['pseudo']) : '';
        $email   = !empty($_POST['email']) ? Wo_Secure($_POST['email']) : '';
        $phone   = !empty($_POST['phone']) ? Wo_Secure($_POST['phone']) : '';
    }

    // --- ÉTAPE 3: Traitement des Fichiers ---
    $file_paths = array();
    if (!empty($_FILES['evidences'])) {
        $files = Wo_MultipleArrayFiles($_FILES['evidences']);
        foreach ($files as $file_info) {
            if ($file_info['size'] > $wo['config']['maxUpload']) {
                continue;
            }
            $media = Wo_ShareFile($file_info);
            if (!empty($media['filename'])) {
                $file_paths[] = $media['filename'];
            }
        }
    }

    // --- ÉTAPE 4: Insertion en Base de Données ---
    $report_data = array(
        'user_id'        => $user_id,
        'pseudo'         => $pseudo,
        'email'          => $email,
        'phone'          => $phone,
        'event_date'     => Wo_Secure($_POST['event_date']),
        'description'    => Wo_Secure($_POST['description']),
        'specific_needs' => !empty($_POST['specific_needs']) ? json_encode($_POST['specific_needs']) : '[]',
        'evidences'      => json_encode($file_paths),
        'status'         => 'new',
        'time'           => time()
    );

    $report_id = $db->insert(T_VIOLENCE_REPORTS, $report_data);
    
    if ($report_id) {
        $data['status'] = 200;
        $data['message'] = "Votre signalement a été reçu avec succès. Nous vous remercions pour votre confiance.";
    } else {
        $data['message'] = "Erreur lors de l'enregistrement de votre signalement dans la base de données.";
    }

    header("Content-type: application/json");
    echo json_encode($data);
    exit();
}